/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.craft;

import cloud.lemonslice.teastory.blockentity.BambooTrayBlockEntity;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import cloud.lemonslice.teastory.recipe.bamboo_tray.BambooTraySingleInRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.block.NormalHorizontalBlock;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class BambooTrayBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE;

    public BambooTrayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader pLevel, BlockPos pos) {
        return pLevel.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)pLevel, pos, Direction.UP);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private void dropItems(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null) {
            te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(inv -> {
                for (int i = inv.getSlots() - 1; i >= 0; --i) {
                    if (inv.getStackInSlot(i) == ItemStack.f_41583_) continue;
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
                    ((IItemHandlerModifiable)inv).setStackInSlot(i, ItemStack.f_41583_);
                }
            });
        }
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public void m_6810_(BlockState blockState, Level worldIn, BlockPos pos, BlockState pNewState, boolean isMoving) {
        if (pNewState.m_60734_() != this) {
            this.dropItems(worldIn, pos);
        }
        super.m_6810_(blockState, worldIn, pos, pNewState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof BambooTrayBlockEntity) {
            if (worldIn.m_5776_()) {
                ((BambooTrayBlockEntity)te).refreshSeed();
                return InteractionResult.SUCCESS;
            }
            if (!player.m_6144_()) {
                if (((BambooTrayBlockEntity)te).isDoubleClick()) {
                    this.dropItems(worldIn, pos);
                    return InteractionResult.SUCCESS;
                }
                if (!((BambooTrayBlockEntity)te).isWorking()) {
                    this.dropItems(worldIn, pos);
                    te.m_6596_();
                }
                if (!player.m_21120_(handIn).m_41619_()) {
                    te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(inv -> {
                        BambooTraySingleInRecipe recipe = null;
                        for (Recipe r : worldIn.m_7465_().m_44051_()) {
                            if (!r.m_6671_().equals(((BambooTrayBlockEntity)te).getRecipeType()) || !((BambooTraySingleInRecipe)r).getIngredient().test(player.m_21120_(handIn))) continue;
                            recipe = (BambooTraySingleInRecipe)r;
                            break;
                        }
                        if (recipe != null && !recipe.getRecipeOutput().m_41619_()) {
                            player.m_21008_(handIn, inv.insertItem(0, player.m_21120_(handIn), false));
                            te.m_6596_();
                        } else {
                            ((BambooTrayBlockEntity)te).singleClickStart();
                        }
                    });
                    return InteractionResult.SUCCESS;
                }
                if (((BambooTrayBlockEntity)te).isWorking()) {
                    ((BambooTrayBlockEntity)te).singleClickStart();
                }
            } else {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)te), (BlockPos)te.m_58899_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new BambooTrayBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldIn, BlockState state, BlockEntityType<T> blockEntityType) {
        return NormalHorizontalBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityRegister.BAMBOO_TRAY_TYPE.get(), BambooTrayBlockEntity::tick);
    }

    static {
        VoxelShape side_north = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 3.0, 2.0);
        VoxelShape side_south = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 14.0, 16.0, 3.0, 2.0);
        VoxelShape side_west = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 2.0, 3.0, 16.0);
        VoxelShape side_east = VoxelShapeHelper.createVoxelShape(14.0, 0.0, 0.0, 2.0, 3.0, 16.0);
        VoxelShape bottom = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
        SHAPE = Shapes.m_83124_((VoxelShape)side_north, (VoxelShape[])new VoxelShape[]{side_south, side_east, side_west, bottom});
    }
}

